<?php
require_once __DIR__ . '/../config/config.php';

class Statistics {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function generateDailyStats($accountId, $date = null) {
        if (!$date) {
            $date = date('Y-m-d');
        }
        
        $trades = $this->db->fetchAll(
            "SELECT * FROM copied_trades 
             WHERE DATE(close_time) = ? AND status = 'closed'
             AND copy_setting_id IN (
                 SELECT id FROM copy_settings WHERE follower_account_id = ? OR master_account_id = ?
             )",
            [$date, $accountId, $accountId]
        );
        
        $totalTrades = count($trades);
        $winningTrades = 0;
        $losingTrades = 0;
        $totalProfit = 0;
        $totalLoss = 0;
        $largestWin = 0;
        $largestLoss = 0;
        
        foreach ($trades as $trade) {
            if ($trade['profit'] > 0) {
                $winningTrades++;
                $totalProfit += $trade['profit'];
                if ($trade['profit'] > $largestWin) {
                    $largestWin = $trade['profit'];
                }
            } else {
                $losingTrades++;
                $totalLoss += abs($trade['profit']);
                if (abs($trade['profit']) > $largestLoss) {
                    $largestLoss = abs($trade['profit']);
                }
            }
        }
        
        $winRate = $totalTrades > 0 ? ($winningTrades / $totalTrades) * 100 : 0;
        $netProfit = $totalProfit - $totalLoss;
        $profitFactor = $totalLoss > 0 ? $totalProfit / $totalLoss : 0;
        $avgWin = $winningTrades > 0 ? $totalProfit / $winningTrades : 0;
        $avgLoss = $losingTrades > 0 ? $totalLoss / $losingTrades : 0;
        
        $this->db->query(
            "INSERT INTO statistics (account_id, stat_date, total_trades, winning_trades, losing_trades,
             total_profit, total_loss, net_profit, win_rate, profit_factor, average_win, average_loss,
             largest_win, largest_loss)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
             ON DUPLICATE KEY UPDATE
             total_trades = VALUES(total_trades),
             winning_trades = VALUES(winning_trades),
             losing_trades = VALUES(losing_trades),
             total_profit = VALUES(total_profit),
             total_loss = VALUES(total_loss),
             net_profit = VALUES(net_profit),
             win_rate = VALUES(win_rate),
             profit_factor = VALUES(profit_factor),
             average_win = VALUES(average_win),
             average_loss = VALUES(average_loss),
             largest_win = VALUES(largest_win),
             largest_loss = VALUES(largest_loss)",
            [
                $accountId, $date, $totalTrades, $winningTrades, $losingTrades,
                $totalProfit, $totalLoss, $netProfit, $winRate, $profitFactor,
                $avgWin, $avgLoss, $largestWin, $largestLoss
            ]
        );
        
        return true;
    }
    
    public function getAccountStats($accountId, $days = 30) {
        return $this->db->fetchAll(
            "SELECT * FROM statistics 
             WHERE account_id = ? AND stat_date >= DATE_SUB(CURDATE(), INTERVAL ? DAY)
             ORDER BY stat_date DESC",
            [$accountId, $days]
        );
    }
}
