<?php
require_once __DIR__ . '/../../config/config.php';

if (!isLoggedIn()) {
    redirect('/public/auth/login.php');
}

$user = getCurrentUser();
$db = Database::getInstance();

$myAccounts = $db->fetchAll("SELECT * FROM mt_accounts WHERE user_id = ?", [$user['id']]);
$myCopies = $db->fetchAll("SELECT * FROM copy_settings WHERE follower_account_id IN (SELECT id FROM mt_accounts WHERE user_id = ?)", [$user['id']]);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="navbar">
        <div class="container">
            <a href="#" class="navbar-brand">Copy Trading Pro</a>
            <div>
                <span>Hola, <?php echo $user['full_name']; ?></span> |
                <a href="../auth/logout.php">Salir</a>
            </div>
        </div>
    </div>
    
    <div class="container" style="margin-top: 2rem;">
        <h1>Mi Dashboard</h1>
        
        <div class="card">
            <h2>Mis Cuentas MT</h2>
            <?php if (count($myAccounts) > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Cuenta</th>
                            <th>Broker</th>
                            <th>Balance</th>
                            <th>Tipo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($myAccounts as $account): ?>
                        <tr>
                            <td><?php echo $account['account_number']; ?></td>
                            <td><?php echo $account['broker']; ?></td>
                            <td><?php echo formatCurrency($account['balance']); ?></td>
                            <td><?php echo $account['is_master'] ? 'Master' : 'Follower'; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No tienes cuentas conectadas. <a href="cuentas.php">Conecta una cuenta</a></p>
            <?php endif; ?>
        </div>
        
        <div class="card" style="margin-top: 1rem;">
            <h2>Mis Configuraciones de Copy</h2>
            <?php if (count($myCopies) > 0): ?>
                <p>Tienes <?php echo count($myCopies); ?> configuraciones activas</p>
            <?php else: ?>
                <p>No estás copiando a ningún trader. <a href="traders.php">Buscar traders</a></p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>