<?php
require_once __DIR__ . '/../../config/config.php';

if (!isLoggedIn() || !hasRole('admin')) {
    redirect('/public/auth/login.php');
}

$user = getCurrentUser();
$db = Database::getInstance();

$totalUsers = $db->fetchColumn("SELECT COUNT(*) FROM users");
$totalAccounts = $db->fetchColumn("SELECT COUNT(*) FROM mt_accounts");
$activeCopies = $db->fetchColumn("SELECT COUNT(*) FROM copy_settings WHERE is_active = 1");
$recentUsers = $db->fetchAll("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard Admin - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="navbar">
        <div class="container">
            <a href="#" class="navbar-brand">Copy Trading Pro - Admin</a>
            <div>
                <span>Hola, <?php echo $user['full_name']; ?></span> |
                <a href="../auth/logout.php">Salir</a>
            </div>
        </div>
    </div>
    
    <div class="container" style="margin-top: 2rem;">
        <h1>Dashboard Administrativo</h1>
        
        <div class="stats-grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1rem; margin: 2rem 0;">
            <div class="card" style="background: var(--primary); color: white;">
                <h3><?php echo $totalUsers; ?></h3>
                <p>Total Usuarios</p>
            </div>
            <div class="card" style="background: var(--secondary); color: white;">
                <h3><?php echo $totalAccounts; ?></h3>
                <p>Cuentas MT</p>
            </div>
            <div class="card" style="background: var(--success); color: white;">
                <h3><?php echo $activeCopies; ?></h3>
                <p>Copias Activas</p>
            </div>
        </div>
        
        <div class="card">
            <h2>Usuarios Recientes</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Registrado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentUsers as $u): ?>
                    <tr>
                        <td><?php echo $u['id']; ?></td>
                        <td><?php echo $u['full_name']; ?></td>
                        <td><?php echo $u['email']; ?></td>
                        <td><?php echo $u['role']; ?></td>
                        <td><?php echo formatDate($u['created_at']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>