#!/usr/bin/env python3
import os

files = {
    'public/auth/login.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

if (isLoggedIn()) {
    redirect('/');
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Login - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="container" style="max-width: 400px; margin-top: 100px;">
        <div class="card">
            <h1 style="text-align: center; color: var(--primary);">Copy Trading Pro</h1>
            <h2 style="text-align: center;">Iniciar Sesión</h2>
            <form action="process-login.php" method="POST">
                <div class="form-group">
                    <label>Email:</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Contraseña:</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%;">Entrar</button>
            </form>
            <p style="text-align: center; margin-top: 1rem;">
                ¿No tienes cuenta? <a href="register.php">Regístrate</a>
            </p>
        </div>
    </div>
</body>
</html>''',

    'public/auth/register.php': '''<?php
require_once __DIR__ . '/../../config/config.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Registro - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="container" style="max-width: 500px; margin-top: 50px;">
        <div class="card">
            <h1 style="text-align: center; color: var(--primary);">Crear Cuenta</h1>
            <form action="process-register.php" method="POST">
                <div class="form-group">
                    <label>Nombre Completo:</label>
                    <input type="text" name="full_name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Email:</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Contraseña:</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Teléfono:</label>
                    <input type="tel" name="phone" class="form-control">
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%;">Registrarse</button>
            </form>
            <p style="text-align: center; margin-top: 1rem;">
                ¿Ya tienes cuenta? <a href="login.php">Inicia sesión</a>
            </p>
        </div>
    </div>
</body>
</html>''',

    'public/auth/process-login.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = cleanInput($_POST['email']);
    $password = $_POST['password'];
    
    $user = new User();
    $result = $user->login($email, $password);
    
    if ($result['success']) {
        redirect('/');
    } else {
        $_SESSION['error'] = $result['message'];
        redirect('/public/auth/login.php');
    }
}
''',

    'public/auth/process-register.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = cleanInput($_POST['email']);
    $password = $_POST['password'];
    $fullName = cleanInput($_POST['full_name']);
    $phone = cleanInput($_POST['phone'] ?? '');
    
    $user = new User();
    $result = $user->register($email, $password, $fullName, $phone);
    
    if ($result['success']) {
        $_SESSION['success'] = 'Cuenta creada exitosamente';
        redirect('/public/auth/login.php');
    } else {
        $_SESSION['error'] = $result['message'];
        redirect('/public/auth/register.php');
    }
}
''',

    'public/auth/logout.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

$user = new User();
$user->logout();

redirect('/public/auth/login.php');
''',

    'public/admin/dashboard.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

if (!isLoggedIn() || !hasRole('admin')) {
    redirect('/public/auth/login.php');
}

$user = getCurrentUser();
$db = Database::getInstance();

$totalUsers = $db->fetchColumn("SELECT COUNT(*) FROM users");
$totalAccounts = $db->fetchColumn("SELECT COUNT(*) FROM mt_accounts");
$activeCopies = $db->fetchColumn("SELECT COUNT(*) FROM copy_settings WHERE is_active = 1");
$recentUsers = $db->fetchAll("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard Admin - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="navbar">
        <div class="container">
            <a href="#" class="navbar-brand">Copy Trading Pro - Admin</a>
            <div>
                <span>Hola, <?php echo $user['full_name']; ?></span> |
                <a href="../auth/logout.php">Salir</a>
            </div>
        </div>
    </div>
    
    <div class="container" style="margin-top: 2rem;">
        <h1>Dashboard Administrativo</h1>
        
        <div class="stats-grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1rem; margin: 2rem 0;">
            <div class="card" style="background: var(--primary); color: white;">
                <h3><?php echo $totalUsers; ?></h3>
                <p>Total Usuarios</p>
            </div>
            <div class="card" style="background: var(--secondary); color: white;">
                <h3><?php echo $totalAccounts; ?></h3>
                <p>Cuentas MT</p>
            </div>
            <div class="card" style="background: var(--success); color: white;">
                <h3><?php echo $activeCopies; ?></h3>
                <p>Copias Activas</p>
            </div>
        </div>
        
        <div class="card">
            <h2>Usuarios Recientes</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Registrado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentUsers as $u): ?>
                    <tr>
                        <td><?php echo $u['id']; ?></td>
                        <td><?php echo $u['full_name']; ?></td>
                        <td><?php echo $u['email']; ?></td>
                        <td><?php echo $u['role']; ?></td>
                        <td><?php echo formatDate($u['created_at']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>''',

    'public/user/dashboard.php': '''<?php
require_once __DIR__ . '/../../config/config.php';

if (!isLoggedIn()) {
    redirect('/public/auth/login.php');
}

$user = getCurrentUser();
$db = Database::getInstance();

$myAccounts = $db->fetchAll("SELECT * FROM mt_accounts WHERE user_id = ?", [$user['id']]);
$myCopies = $db->fetchAll("SELECT * FROM copy_settings WHERE follower_account_id IN (SELECT id FROM mt_accounts WHERE user_id = ?)", [$user['id']]);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - Copy Trading Pro</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
    <div class="navbar">
        <div class="container">
            <a href="#" class="navbar-brand">Copy Trading Pro</a>
            <div>
                <span>Hola, <?php echo $user['full_name']; ?></span> |
                <a href="../auth/logout.php">Salir</a>
            </div>
        </div>
    </div>
    
    <div class="container" style="margin-top: 2rem;">
        <h1>Mi Dashboard</h1>
        
        <div class="card">
            <h2>Mis Cuentas MT</h2>
            <?php if (count($myAccounts) > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Cuenta</th>
                            <th>Broker</th>
                            <th>Balance</th>
                            <th>Tipo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($myAccounts as $account): ?>
                        <tr>
                            <td><?php echo $account['account_number']; ?></td>
                            <td><?php echo $account['broker']; ?></td>
                            <td><?php echo formatCurrency($account['balance']); ?></td>
                            <td><?php echo $account['is_master'] ? 'Master' : 'Follower'; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No tienes cuentas conectadas. <a href="cuentas.php">Conecta una cuenta</a></p>
            <?php endif; ?>
        </div>
        
        <div class="card" style="margin-top: 1rem;">
            <h2>Mis Configuraciones de Copy</h2>
            <?php if (count($myCopies) > 0): ?>
                <p>Tienes <?php echo count($myCopies); ?> configuraciones activas</p>
            <?php else: ?>
                <p>No estás copiando a ningún trader. <a href="traders.php">Buscar traders</a></p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>''',

    'cron/sync.php': '''<?php
require_once __DIR__ . '/../config/config.php';

$copyTrading = new CopyTrading();
$copyTrading->syncTrades();

logMessage('info', 'Copy trading sync completed');
''',

    'README.md': '''# Copy Trading Pro

Sistema completo de copy trading para MetaTrader 4/5

## Instalación

1. Crear base de datos MySQL
2. Importar `database/schema.sql`
3. Configurar `config/config.php`
4. Configurar servidor web (Apache/Nginx)
5. Instalar dependencias si es necesario

## Configuración

### Base de Datos
Edita `config/config.php` y configura:
- DB_HOST
- DB_NAME
- DB_USER
- DB_PASS

### MetaAPI
1. Registrarse en metaapi.cloud
2. Obtener API token
3. Configurar METAAPI_TOKEN en config.php

## Uso

### Usuario Admin por Defecto
- Email: admin@copytrading.com
- Password: password

### Agregar Cuenta MT
1. Login como usuario
2. Ir a "Mis Cuentas"
3. Conectar cuenta MT4/MT5

### Configurar Copy Trading
1. Buscar traders
2. Seleccionar trader master
3. Configurar parámetros de copia
4. Activar copy trading

## Estructura

- `/config` - Configuración
- `/src` - Clases PHP
- `/database` - SQL schemas
- `/public` - Archivos públicos
- `/cron` - Scripts automáticos
- `/assets` - CSS/JS/Images

## Características

- ✅ Sistema de usuarios y roles
- ✅ Gestión de cuentas MT4/MT5
- ✅ Copy trading automatizado
- ✅ Suscripciones y pagos
- ✅ Estadísticas y reportes
- ✅ Panel administrativo
- ✅ API REST

## Soporte

Para soporte técnico contactar a: info@copytradingpro.com

## Licencia

Copyright © 2025 Copy Trading Pro
'''
}

for filepath, content in files.items():
    full_path = filepath
    os.makedirs(os.path.dirname(full_path), exist_ok=True)
    with open(full_path, 'w', encoding='utf-8') as f:
        f.write(content)
    print(f"Created: {filepath}")

print("\nAll files created successfully!")
