<?php
/**
 * Copy Trading Pro - Configuración Principal
 */

// Zona horaria
date_default_timezone_set('America/Santo_Domingo');

// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'copy_trading_pro');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Configuración del sitio
define('SITE_NAME', 'Copy Trading Pro');
define('SITE_URL', 'http://localhost/copy-trading-pro');
define('SITE_EMAIL', 'info@copytradingpro.com');

// Rutas del sistema
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('TEMPLATE_PATH', ROOT_PATH . '/templates');
define('UPLOAD_PATH', ROOT_PATH . '/uploads');
define('LOG_PATH', ROOT_PATH . '/logs');

// Configuración de seguridad
define('SECURE_KEY', 'your-secret-key-change-this-in-production');
define('SESSION_LIFETIME', 3600); // 1 hora
define('CSRF_TOKEN_NAME', 'csrf_token');
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutos

// Configuración de MetaAPI
define('METAAPI_TOKEN', 'your-metaapi-token-here');
define('METAAPI_URL', 'https://mt-client-api-v1.agiliumtrade.agiliumtrade.ai');

// Configuración de Stripe
define('STRIPE_PUBLIC_KEY', 'pk_test_your_stripe_public_key');
define('STRIPE_SECRET_KEY', 'sk_test_your_stripe_secret_key');
define('STRIPE_WEBHOOK_SECRET', 'whsec_your_webhook_secret');

// Configuración de PayPal
define('PAYPAL_CLIENT_ID', 'your_paypal_client_id');
define('PAYPAL_SECRET', 'your_paypal_secret');
define('PAYPAL_MODE', 'sandbox'); // 'sandbox' o 'live'

// Configuración de email
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
define('SMTP_FROM_EMAIL', 'noreply@copytradingpro.com');
define('SMTP_FROM_NAME', 'Copy Trading Pro');

// Configuración de sistema
define('ENABLE_REGISTRATION', true);
define('REQUIRE_EMAIL_VERIFICATION', false);
define('DEFAULT_LANGUAGE', 'es');
define('ENABLE_MAINTENANCE_MODE', false);

// Configuración de copy trading
define('SYNC_INTERVAL', 30); // segundos
define('MAX_SLIPPAGE_DEFAULT', 5); // pips
define('MAX_LOT_SIZE_DEFAULT', 10.0);
define('ENABLE_REVERSE_COPY', true);

// Configuración de logs
define('ENABLE_LOGGING', true);
define('LOG_LEVEL', 'debug'); // debug, info, warning, error
define('LOG_MAX_SIZE', 10485760); // 10MB

// Configuración de caché
define('ENABLE_CACHE', false);
define('CACHE_DRIVER', 'file'); // file, redis, memcached
define('CACHE_LIFETIME', 3600);

// Entorno
define('ENVIRONMENT', 'development'); // development, production

// Configuración según entorno
if (ENVIRONMENT === 'production') {
    error_reporting(0);
    ini_set('display_errors', 0);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

// Autoload de clases
spl_autoload_register(function ($class) {
    $file = ROOT_PATH . '/src/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// Iniciar sesión
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Función helper para redireccionar
function redirect($url) {
    header("Location: " . SITE_URL . $url);
    exit;
}

// Función helper para obtener usuario actual
function getCurrentUser() {
    return $_SESSION['user'] ?? null;
}

// Función helper para verificar si está logueado
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Función helper para verificar rol
function hasRole($role) {
    $user = getCurrentUser();
    return $user && $user['role'] === $role;
}

// Función helper para formatear moneda
function formatCurrency($amount, $currency = 'USD') {
    return '$' . number_format($amount, 2);
}

// Función helper para formatear fecha
function formatDate($date, $format = 'Y-m-d H:i:s') {
    if (empty($date)) return '-';
    return date($format, strtotime($date));
}

// Función helper para limpiar input
function cleanInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
}

// Función helper para generar token CSRF
function generateCSRFToken() {
    if (empty($_SESSION[CSRF_TOKEN_NAME])) {
        $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
    }
    return $_SESSION[CSRF_TOKEN_NAME];
}

// Función helper para verificar token CSRF
function verifyCSRFToken($token) {
    return isset($_SESSION[CSRF_TOKEN_NAME]) && hash_equals($_SESSION[CSRF_TOKEN_NAME], $token);
}

// Función helper para logging
function logMessage($level, $message, $context = []) {
    if (!ENABLE_LOGGING) return;
    
    $logFile = LOG_PATH . '/' . date('Y-m-d') . '.log';
    $timestamp = date('Y-m-d H:i:s');
    $contextStr = !empty($context) ? ' ' . json_encode($context) : '';
    $logLine = "[$timestamp] [$level] $message$contextStr" . PHP_EOL;
    
    if (!is_dir(LOG_PATH)) {
        mkdir(LOG_PATH, 0755, true);
    }
    
    file_put_contents($logFile, $logLine, FILE_APPEND);
}

// Función helper para obtener IP del usuario
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    }
}

// Función helper para validar email
function isValidEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

// Función helper para generar password aleatorio
function generateRandomPassword($length = 12) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
    return substr(str_shuffle(str_repeat($chars, ceil($length / strlen($chars)))), 0, $length);
}
