# Copy Trading Pro

Sistema completo de copy trading para MetaTrader 4/5 con suscripciones

## 🚀 Características

- ✅ Sistema de usuarios (Admin, Trader, Follower)
- ✅ Gestión de cuentas MT4/MT5
- ✅ Copy trading automatizado en tiempo real
- ✅ Sistema de suscripciones con múltiples planes
- ✅ Pagos con Stripe y PayPal
- ✅ Estadísticas y reportes detallados
- ✅ Panel administrativo completo
- ✅ Dashboard de usuario intuitivo
- ✅ API REST documentada
- ✅ Notificaciones en tiempo real
- ✅ Sistema de logs y seguridad

## 📋 Requisitos

- PHP 7.4 o superior
- MySQL 5.7 o superior
- Apache/Nginx
- Extensiones PHP: PDO, curl, json, mbstring
- Cuenta en MetaAPI.cloud (para integración MT4/MT5)

## 🔧 Instalación

### 1. Crear Base de Datos

```sql
CREATE DATABASE copy_trading_pro CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 2. Importar Schema

```bash
mysql -u root -p copy_trading_pro < database/schema.sql
```

### 3. Configurar Sistema

Editar `config/config.php` y configurar:

```php
// Base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'copy_trading_pro');
define('DB_USER', 'tu_usuario');
define('DB_PASS', 'tu_password');

// MetaAPI
define('METAAPI_TOKEN', 'tu-metaapi-token');

// Stripe (opcional)
define('STRIPE_SECRET_KEY', 'tu-stripe-key');

// PayPal (opcional)
define('PAYPAL_CLIENT_ID', 'tu-paypal-id');
```

### 4. Configurar Servidor Web

#### Apache
Apuntar document root a la carpeta `public/`

#### Nginx
```nginx
server {
    listen 80;
    server_name tudominio.com;
    root /ruta/al/proyecto/public;
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
    }
}
```

### 5. Configurar Cron (Sincronización Automática)

```bash
*/1 * * * * php /ruta/al/proyecto/cron/sync.php
```

## 👤 Usuario Administrador

Por defecto se crea un usuario admin:

- **Email:** admin@copytrading.com
- **Password:** password

**IMPORTANTE:** Cambiar la contraseña después del primer login.

## 📖 Guía de Uso

### Para Usuarios

1. **Registrarse** en el sistema
2. **Conectar cuenta MT4/MT5** desde "Mis Cuentas"
3. **Buscar traders** en el marketplace
4. **Configurar copy trading** con parámetros personalizados
5. **Activar suscripción** para comenzar a copiar

### Para Traders (Masters)

1. Conectar cuenta MT4/MT5 como **Master**
2. Operar normalmente en tu cuenta
3. Los seguidores copiarán automáticamente tus operaciones
4. Ver estadísticas de tus seguidores

### Para Administradores

1. **Gestionar usuarios** (crear, editar, eliminar)
2. **Gestionar planes** de suscripción
3. **Ver estadísticas** generales del sistema
4. **Gestionar pagos** y transacciones
5. **Ver logs** del sistema

## 📁 Estructura del Proyecto

```
copy-trading-pro/
├── config/
│   └── config.php              # Configuración principal
├── src/
│   ├── Database.php            # Clase de conexión BD
│   ├── User.php                # Gestión de usuarios
│   ├── MetaTraderAPI.php       # Integración MT4/MT5
│   ├── CopyTrading.php         # Motor de copy trading
│   ├── Subscription.php        # Sistema de suscripciones
│   └── Statistics.php          # Generación de estadísticas
├── database/
│   └── schema.sql              # Schema de base de datos
├── public/
│   ├── index.php               # Punto de entrada
│   ├── auth/                   # Login, registro, logout
│   ├── admin/                  # Panel administrativo
│   ├── user/                   # Dashboard de usuario
│   └── api/                    # API REST
├── assets/
│   ├── css/                    # Estilos
│   ├── js/                     # JavaScript
│   └── images/                 # Imágenes
├── cron/
│   └── sync.php                # Sincronización automática
└── logs/                       # Logs del sistema
```

## 🔌 Integración MetaAPI

### 1. Crear Cuenta

Registrarse en [metaapi.cloud](https://metaapi.cloud)

### 2. Obtener API Token

1. Ir a "API tokens"
2. Crear nuevo token
3. Copiar y pegar en `config.php`

### 3. Conectar Cuenta MT

```php
$mtApi = new MetaTraderAPI();
$result = $mtApi->connectAccount(
    $accountNumber,
    $broker,
    $server,
    $password,
    'mt4' // o 'mt5'
);
```

## 💳 Configurar Pagos

### Stripe

1. Crear cuenta en [stripe.com](https://stripe.com)
2. Obtener API keys
3. Configurar en `config.php`

### PayPal

1. Crear app en [developer.paypal.com](https://developer.paypal.com)
2. Obtener Client ID y Secret
3. Configurar en `config.php`

## 🛡️ Seguridad

- Contraseñas hasheadas con bcrypt
- Prepared statements para prevenir SQL injection
- Protección CSRF
- Sanitización de inputs
- Logs de seguridad
- Sesiones seguras

## 📊 API REST

### Endpoints Disponibles

```
GET  /api/users              # Lista de usuarios
GET  /api/accounts           # Cuentas MT
POST /api/copy-settings      # Crear copy setting
GET  /api/statistics         # Estadísticas
POST /api/trade              # Ejecutar trade
```

## 🐛 Troubleshooting

### Error de conexión a base de datos
- Verificar credenciales en `config.php`
- Verificar que MySQL esté corriendo
- Verificar permisos del usuario de BD

### No se copian las operaciones
- Verificar configuración MetaAPI
- Revisar logs en carpeta `logs/`
- Verificar que el cron esté corriendo
- Verificar que las cuentas estén activas

### Errores de permisos
```bash
chmod -R 755 /ruta/al/proyecto
chmod -R 777 /ruta/al/proyecto/logs
```

## 📈 Próximas Funcionalidades

- [ ] App móvil (iOS/Android)
- [ ] Trading social (feed, comentarios)
- [ ] Backtesting de estrategias
- [ ] Inteligencia artificial
- [ ] Multi-idioma completo
- [ ] Sistema de comisiones
- [ ] Marketplace de traders avanzado

## 🤝 Soporte

- Email: info@copytradingpro.com
- Documentación: https://docs.copytradingpro.com
- Issues: GitHub Issues

## 📄 Licencia

Copyright © 2025 Copy Trading Pro. Todos los derechos reservados.

## 👨‍💻 Autor

Desarrollado con ❤️ para la comunidad de traders

---

**¡Disfruta tu plataforma de Copy Trading!** 🚀📈
